(

    struct AMGData 
	(
		fn GetUUID mtl context =
		(
			"da453cd9-b375-42dc-93c0-661fd54e074c"
		),

		fn GetMaps mtl context =
		(
			local res = #()	

			-- Can deal with color, bump, float and alpha
			if mtl.map1 != undefined and mtl.map1Enabled do	(
			    append res #( "input",      mtl.map1, "result")
			    append res #( "inputBump",  mtl.map1, "normalPerturb")
			    append res #( "inputFloat", mtl.map1, "resultFloat")
			    append res #( "alpha",      mtl.map1, "alpha")
			)

			res
		),

		fn GetParams mtl context = 
		(
			local res = #()	

			append res #( "input",			(color 255 255 255)) -- if no color connected - use white
			append res #( "alpha",			1.0)                 -- if no alpha connected - use 1.0
			append res #( "invert",			mtl.output.invert)                   
			append res #( "clamp",			mtl.output.clamp )  
			append res #( "rgb_level",		mtl.output.RGB_Level )  
			append res #( "rgb_offset",		mtl.output.RGB_Offset )  
			append res #( "out_amount",		mtl.output.Output_Amount )  
			append res #( "bump_amount",	mtl.output.Bump_Amount )  

			append res #( "curves",			mtl, "output" ) -- Attach and translate the "output" rollout  

 			res
		)
	)

	AMGData()
)